/**
 * @file IEvolutionGeniviDbusGeniviTraceSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for GeniviTrace.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusGeniviTraceCallbackIf;

/**
 * Send request interface class for GeniviTrace.
 */
class IEvolutionGeniviDbusGeniviTraceSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusGeniviTraceSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusGeniviTraceCallbackIf* callbackIf, bool enableProxy) = 0;

};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_SEND_REQUEST_IF_H_
