/**
 * @file IEvolutionGeniviDbusGeniviTraceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for GeniviTrace.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_

#include "org/bluez/genivi/TraceProxy.h"

using namespace ::org::bluez::genivi::Trace;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for GeniviTrace.
 */
class IEvolutionGeniviDbusGeniviTraceCallbackIf :
   // from org/bluez/genivi/TraceProxy.h --- start
   public ReportDebugTraceCallbackIF,
   public FatalErrorCallbackIF
   // from org/bluez/genivi/TraceProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusGeniviTraceCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/genivi/TraceProxy implementation --- start
   virtual void onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error) = 0;

   virtual void onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal) = 0;

   virtual void onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error) = 0;

   virtual void onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal) = 0;
   // org/bluez/genivi/TraceProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_
