/**
 * @file IEvolutionGeniviDbusDunCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Dun.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Dun.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DUN_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DUN_CALLBACK_IF_H_

#include "org/alps/evo/DUNProxy.h"

using namespace ::org::alps::evo::DUN;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Dun.
 */
class IEvolutionGeniviDbusDunCallbackIf :
   // from org/alps/evo/DUNProxy.h --- start
   public BtApplDunSendDataReqCallbackIF,
   public BtApplDunFlowCtrlReqCallbackIF,
   public BtApplDunSendDataCfmCallbackIF,
   public BtApplDunSendIndCallbackIF,
   public BtApplDunDataIndCallbackIF,
   public BtApplDunDataSendFcIndCallbackIF,
   public BtApplDunFlowCtrlCfmCallbackIF
   // from org/alps/evo/DUNProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDunCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/DUNProxy implementation --- start
   virtual void onBtApplDunSendDataReqError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataReqError >& error) = 0;

   virtual void onBtApplDunSendDataReqResponse(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataReqResponse >& response) = 0;

   virtual void onBtApplDunFlowCtrlReqError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlReqError >& error) = 0;

   virtual void onBtApplDunFlowCtrlReqResponse(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlReqResponse >& response) = 0;

   virtual void onBtApplDunSendDataCfmError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataCfmError >& error) = 0;

   virtual void onBtApplDunSendDataCfmSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendDataCfmSignal >& signal) = 0;

   virtual void onBtApplDunSendIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendIndError >& error) = 0;

   virtual void onBtApplDunSendIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunSendIndSignal >& signal) = 0;

   virtual void onBtApplDunDataIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataIndError >& error) = 0;

   virtual void onBtApplDunDataIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataIndSignal >& signal) = 0;

   virtual void onBtApplDunDataSendFcIndError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataSendFcIndError >& error) = 0;

   virtual void onBtApplDunDataSendFcIndSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunDataSendFcIndSignal >& signal) = 0;

   virtual void onBtApplDunFlowCtrlCfmError(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlCfmError >& error) = 0;

   virtual void onBtApplDunFlowCtrlCfmSignal(const ::boost::shared_ptr< DUNProxy >& proxy, const ::boost::shared_ptr< BtApplDunFlowCtrlCfmSignal >& signal) = 0;
   // org/alps/evo/DUNProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DUN_CALLBACK_IF_H_
