/**
 * @file IEvolutionGeniviDbusDMCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for DM.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for DM.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_

#include "org/alps/evo/DMProxy.h"

using namespace ::org::alps::evo::DM;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for DM.
 */
class IEvolutionGeniviDbusDMCallbackIf :
   // from org/alps/evo/DMProxy.h --- start
   public BtApplDeviceConnectReqCallbackIF,
   public BtApplDeviceDisconnectReqCallbackIF,
   public BtApplCancelConnectReqCallbackIF,
   public BtApplGetHwVersionReqCallbackIF,
   public BtApplSetConfigurationReqCallbackIF,
   public BtApplReadConfigurationReqCallbackIF,
   public BtApplSspDebugModeReqCallbackIF,
   public BtApplTestModeReqCallbackIF,
   public BtApplTestModeLinkQualityReqCallbackIF,
   public BtApplDeviceConnectCfmCallbackIF,
   public BtApplDeviceConnectIndCallbackIF,
   public BtApplDeviceDisconnectCfmCallbackIF,
   public BtApplDeviceDisconnectIndCallbackIF,
   public BtApplDeviceDisconnectCompIndCallbackIF,
   public BtApplDeviceConnectCompIndCallbackIF,
   public BtApplCancelConnectCfmCallbackIF,
   public BtApplStatusNotificationIndCallbackIF,
   public BtApplGetHwVersionCfmCallbackIF,
   public BtApplSetConfigurationCfmCallbackIF,
   public BtApplReadConfigurationCfmCallbackIF,
   public BtApplTestModeCfmCallbackIF,
   public BtApplTestModeCompIndCallbackIF,
   public BtApplTestModeLinkQualityCfmCallbackIF
   // from org/alps/evo/DMProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDMCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/DMProxy implementation --- start
   virtual void onBtApplDeviceConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqError >& error) = 0;

   virtual void onBtApplDeviceConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqResponse >& response) = 0;

   virtual void onBtApplDeviceDisconnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqError >& error) = 0;

   virtual void onBtApplDeviceDisconnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqResponse >& response) = 0;

   virtual void onBtApplCancelConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqError >& error) = 0;

   virtual void onBtApplCancelConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqResponse >& response) = 0;

   virtual void onBtApplGetHwVersionReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqError >& error) = 0;

   virtual void onBtApplGetHwVersionReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqResponse >& response) = 0;

   virtual void onBtApplSetConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqError >& error) = 0;

   virtual void onBtApplSetConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqResponse >& response) = 0;

   virtual void onBtApplReadConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqError >& error) = 0;

   virtual void onBtApplReadConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqResponse >& response) = 0;

   virtual void onBtApplSspDebugModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqError >& error) = 0;

   virtual void onBtApplSspDebugModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqResponse >& response) = 0;

   virtual void onBtApplTestModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqError >& error) = 0;

   virtual void onBtApplTestModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqResponse >& response) = 0;

   virtual void onBtApplTestModeLinkQualityReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqError >& error) = 0;

   virtual void onBtApplTestModeLinkQualityReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqResponse >& response) = 0;

   virtual void onBtApplDeviceConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmError >& error) = 0;

   virtual void onBtApplDeviceConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmSignal >& signal) = 0;

   virtual void onBtApplDeviceConnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndError >& error) = 0;

   virtual void onBtApplDeviceConnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndSignal >& signal) = 0;

   virtual void onBtApplDeviceDisconnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmError >& error) = 0;

   virtual void onBtApplDeviceDisconnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmSignal >& signal) = 0;

   virtual void onBtApplDeviceDisconnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndError >& error) = 0;

   virtual void onBtApplDeviceDisconnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndSignal >& signal) = 0;

   virtual void onBtApplDeviceDisconnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndError >& error) = 0;

   virtual void onBtApplDeviceDisconnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndSignal >& signal) = 0;

   virtual void onBtApplDeviceConnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndError >& error) = 0;

   virtual void onBtApplDeviceConnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndSignal >& signal) = 0;

   virtual void onBtApplCancelConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmError >& error) = 0;

   virtual void onBtApplCancelConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmSignal >& signal) = 0;

   virtual void onBtApplStatusNotificationIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndError >& error) = 0;

   virtual void onBtApplStatusNotificationIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndSignal >& signal) = 0;

   virtual void onBtApplGetHwVersionCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmError >& error) = 0;

   virtual void onBtApplGetHwVersionCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmSignal >& signal) = 0;

   virtual void onBtApplSetConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmError >& error) = 0;

   virtual void onBtApplSetConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmSignal >& signal) = 0;

   virtual void onBtApplReadConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmError >& error) = 0;

   virtual void onBtApplReadConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmSignal >& signal) = 0;

   virtual void onBtApplTestModeCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmError >& error) = 0;

   virtual void onBtApplTestModeCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmSignal >& signal) = 0;

   virtual void onBtApplTestModeCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndError >& error) = 0;

   virtual void onBtApplTestModeCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndSignal >& signal) = 0;

   virtual void onBtApplTestModeLinkQualityCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmError >& error) = 0;

   virtual void onBtApplTestModeLinkQualityCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmSignal >& signal) = 0;
   // org/alps/evo/DMProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_
