/**
 * @file IEvolutionGeniviDbusAgentCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Agent.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_AGENT_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_AGENT_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "org/bluez/AgentStub.h"

using namespace ::org::bluez::Agent;

namespace ccdbusif {

/**
 * Callback interface class for Agent.
 */
class IEvolutionGeniviDbusAgentCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusAgentCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   // --- not needed because Agent interface is provided by local side ---
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/AgentStub implementation --- start
   /**
    * onReleaseRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request, const act_t act) = 0;

   /**
    * onRequestPinCodeRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request, const act_t act) = 0;

   /**
    * onDisplayPinCodeRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request, const act_t act) = 0;

   /**
    * onRequestPasskeyRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request, const act_t act) = 0;

   /**
    * onRequestConfirmationRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request, const act_t act) = 0;

   /**
    * onCancelRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request, const act_t act) = 0;

   /**
    * onCancelRequestRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request, const act_t act) = 0;

   /**
    * onAuthorizeServiceRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request, const act_t act) = 0;

   /**
    * onRequestAuthorizationRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request, const act_t act) = 0;

   /**
    * onRequestLinkkeyRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request, const act_t act) = 0;

   /**
    * onDisplayPasskeyRequest.
    *
    * @param[in] request: request
    * @param[in] act: act
    */
   virtual void onDisplayPasskeyRequest (const ::boost::shared_ptr< DisplayPasskeyRequest >& request, const act_t act) = 0;
   // org/bluez/AgentStub implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_AGENT_CALLBACK_IF_H_
