/**
 * @file IEvolutionGeniviDbusAdapterCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Adapter.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_ADAPTER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_ADAPTER_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "org/bluez/Adapter1.h"

using namespace ::org::bluez::Adapter1;

namespace ccdbusif {

/**
 * Callback interface class for Adapter.
 */
class IEvolutionGeniviDbusAdapterCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusAdapterCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   /**
    * Available signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Unavailable signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/Adapter1Proxy implementation --- start
   /**
    * onStartDiscoveryError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onStartDiscoveryErrorCb(const ::boost::shared_ptr< StartDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onStartDiscoveryResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onStartDiscoveryResponseCb(const ::boost::shared_ptr< StartDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onStopDiscoveryError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onStopDiscoveryErrorCb(const ::boost::shared_ptr< StopDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onStopDiscoveryResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onStopDiscoveryResponseCb(const ::boost::shared_ptr< StopDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onRemoveDeviceError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onRemoveDeviceErrorCb(const ::boost::shared_ptr< RemoveDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onRemoveDeviceResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onRemoveDeviceResponseCb(const ::boost::shared_ptr< RemoveDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onCreateDeviceError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onCreateDeviceErrorCb(const ::boost::shared_ptr< CreateDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onCreateDeviceResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onCreateDeviceResponseCb(const ::boost::shared_ptr< CreateDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onSendHCICmdError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSendHCICmdErrorCb(const ::boost::shared_ptr< SendHCICmdError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onSendHCICmdResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSendHCICmdResponseCb(const ::boost::shared_ptr< SendHCICmdResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAdapterInitializationError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAdapterInitializationErrorCb(const ::boost::shared_ptr< AdapterInitializationError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAdapterInitializationSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAdapterInitializationSignalCb(const ::boost::shared_ptr< AdapterInitializationSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceCreatedError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceCreatedErrorCb(const ::boost::shared_ptr< DeviceCreatedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceCreatedSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceCreatedSignalCb(const ::boost::shared_ptr< DeviceCreatedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceRemovedError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceRemovedErrorCb(const ::boost::shared_ptr< DeviceRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceRemovedSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceRemovedSignalCb(const ::boost::shared_ptr< DeviceRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onBtStackLogError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onBtStackLogErrorCb(const ::boost::shared_ptr< BtStackLogError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onBtStackLogSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onBtStackLogSignalCb(const ::boost::shared_ptr< BtStackLogSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onHCIEventError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onHCIEventErrorCb(const ::boost::shared_ptr< HCIEventError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onHCIEventSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onHCIEventSignalCb(const ::boost::shared_ptr< HCIEventSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceFoundError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceFoundErrorCb(const ::boost::shared_ptr< DeviceFoundError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceFoundSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceFoundSignalCb(const ::boost::shared_ptr< DeviceFoundSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAddressError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAddressErrorCb(const ::boost::shared_ptr< AddressError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAddressUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAddressUpdateCb(const ::boost::shared_ptr< AddressUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onClassError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onClassErrorCb(const ::boost::shared_ptr< ClassError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onClassUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onClassUpdateCb(const ::boost::shared_ptr< ClassUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAliasError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAliasErrorCb(const ::boost::shared_ptr< AliasError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAliasUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAliasUpdateCb(const ::boost::shared_ptr< AliasUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPoweredError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPoweredErrorCb(const ::boost::shared_ptr< PoweredError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPoweredUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPoweredUpdateCb(const ::boost::shared_ptr< PoweredUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoverableError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoverableErrorCb(const ::boost::shared_ptr< DiscoverableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoverableUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoverableUpdateCb(const ::boost::shared_ptr< DiscoverableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoverableTimeoutError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoverableTimeoutErrorCb(const ::boost::shared_ptr< DiscoverableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoverableTimeoutUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoverableTimeoutUpdateCb(const ::boost::shared_ptr< DiscoverableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPairableError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPairableErrorCb(const ::boost::shared_ptr< PairableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPairableUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPairableUpdateCb(const ::boost::shared_ptr< PairableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPairableTimeoutError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPairableTimeoutErrorCb(const ::boost::shared_ptr< PairableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onPairableTimeoutUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onPairableTimeoutUpdateCb(const ::boost::shared_ptr< PairableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoveringError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoveringErrorCb(const ::boost::shared_ptr< DiscoveringError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDiscoveringUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDiscoveringUpdateCb(const ::boost::shared_ptr< DiscoveringUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onUUIDsError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onUUIDsErrorCb(const ::boost::shared_ptr< UUIDsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onUUIDsUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onUUIDsUpdateCb(const ::boost::shared_ptr< UUIDsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onWBSModeError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onWBSModeErrorCb(const ::boost::shared_ptr< WBSModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onWBSModeUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onWBSModeUpdateCb(const ::boost::shared_ptr< WBSModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onConnectableError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onConnectableErrorCb(const ::boost::shared_ptr< ConnectableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onConnectableUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onConnectableUpdateCb(const ::boost::shared_ptr< ConnectableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onHCIModeError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onHCIModeErrorCb(const ::boost::shared_ptr< HCIModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onHCIModeUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onHCIModeUpdateCb(const ::boost::shared_ptr< HCIModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onVersionError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onVersionErrorCb(const ::boost::shared_ptr< VersionError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onVersionUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onVersionUpdateCb(const ::boost::shared_ptr< VersionUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onTraceLevelError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onTraceLevelErrorCb(const ::boost::shared_ptr< TraceLevelError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onTraceLevelUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onTraceLevelUpdateCb(const ::boost::shared_ptr< TraceLevelUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onTraceCategoryError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onTraceCategoryErrorCb(const ::boost::shared_ptr< TraceCategoryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onTraceCategoryUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onTraceCategoryUpdateCb(const ::boost::shared_ptr< TraceCategoryUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAvailableSPPServersError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAvailableSPPServersErrorCb(const ::boost::shared_ptr< AvailableSPPServersError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onAvailableSPPServersUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onAvailableSPPServersUpdateCb(const ::boost::shared_ptr< AvailableSPPServersUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // org/bluez/Adapter1Proxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_ADAPTER_CALLBACK_IF_H_
