/**
 * @file EvolutionGeniviDbusTraceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Trace.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_TRACE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_TRACE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusTraceSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/evo/TraceProxy.h"

using namespace ::org::bluez::evo::Trace;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusTraceCallbackIf;

/**
 * Trace proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusTraceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusTraceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusTraceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusTraceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusTraceCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusTraceProxyIf implementation --- start
   virtual act_t sendDebugTraceConfigRequest(uint8 level, uint32 current_time, uint8 mode, uint32 category1, uint32 category2, uint32 category3);

   virtual act_t sendProtocolTraceConfigRequest(uint16 filter);
   // IEvolutionGeniviDbusTraceProxyIf implementation --- end

protected:
   EvolutionGeniviDbusTraceProxyIf();

private:
   ::boost::shared_ptr< TraceProxy > _traceProxy;
   IEvolutionGeniviDbusTraceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_TRACE_PROXY_IF_H_
