/**
 * @file EvolutionGeniviDbusServiceProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Service.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SERVICE_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_SERVICE_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Service properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusServiceProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusServiceProperties();
   virtual ~EvolutionGeniviDbusServiceProperties();

   ServiceProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const ServiceProperty value) const;
   const ::std::string& getProperty2StringTrace(const ServiceProperty value) const;

private:
   const ::std::string _propertyRemoteUUID;
   const ::std::string _propertyState;
   const ::std::string _propertyDevice;
   const ::std::string _propertyVersion;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_SERVICE_PROPERTIES_H_
