/**
 * @file EvolutionGeniviDbusSerialProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Serial.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SERIAL_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_SERIAL_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Serial properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusSerialProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusSerialProperties();
   virtual ~EvolutionGeniviDbusSerialProperties();

   SerialProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const SerialProperty value) const;
   const ::std::string& getProperty2StringTrace(const SerialProperty value) const;

private:
   const ::std::string _propertyFlowCtrlRecv;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_SERIAL_PROPERTIES_H_
