/**
 * @file EvolutionGeniviDbusObexTransferProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for ObexTransfer.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusObexTransferSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/obex/TransferProxy.h"

using namespace ::org::bluez::obex::Transfer;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusObexTransferCallbackIf;

/**
 * ObexTransfer proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexTransferProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusObexTransferSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusObexTransferProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusObexTransferProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusObexTransferCallbackIf* callbackIf, bool enableProxy);

   virtual void transferCreated(const ::std::string& objPath);

   virtual void transferRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IEvolutionGeniviDbusObexTransferProxyIf implementation --- start
   virtual act_t sendCancelRequest(const ::std::string& objPath);

   virtual act_t sendStatusGet(const ::std::string& objPath);

   virtual act_t sendSessionGet(const ::std::string& objPath);

   virtual act_t sendNameGet(const ::std::string& objPath);

   virtual act_t sendTypeGet(const ::std::string& objPath);

   virtual act_t sendTimeGet(const ::std::string& objPath);

   virtual act_t sendSizeGet(const ::std::string& objPath);

   virtual act_t sendTransferredGet(const ::std::string& objPath);

   virtual act_t sendFilenameGet(const ::std::string& objPath);
   // IEvolutionGeniviDbusObexTransferProxyIf implementation --- end

protected:
   EvolutionGeniviDbusObexTransferProxyIf();

private:
   ProxyManager< TransferProxy > _obexTransferProxy;
   IEvolutionGeniviDbusObexTransferCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROXY_IF_H_
