/**
 * @file EvolutionGeniviDbusObexSessionProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexSession.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * ObexSession properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexSessionProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusObexSessionProperties();
   virtual ~EvolutionGeniviDbusObexSessionProperties();

   ObexSessionProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const ObexSessionProperty value) const;
   const ::std::string& getProperty2StringTrace(const ObexSessionProperty value) const;

private:
   const ::std::string _propertySource;
   const ::std::string _propertyDestination;
   const ::std::string _propertyChannel;
   const ::std::string _propertyTarget;
   const ::std::string _propertyInstanceId;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROPERTIES_H_
