/**
 * @file EvolutionGeniviDbusObexClientProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for ObexClient.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusObexClientSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/obex/ClientProxy.h"

using namespace ::org::bluez::obex::Client;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusObexClientCallbackIf;

/**
 * ObexClient proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexClientProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusObexClientSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusObexClientProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusObexClientProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusObexClientCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusObexClientProxyIf implementation --- start
   virtual act_t sendCreateSessionRequest(const ::std::string& destination, const ::std::string& target, const ::std::string& source, const uint8 channel, const int32 instance);

   virtual act_t sendCreateSessionRequest(const ::std::string& destination, const ::std::string& target, const ::std::string& source, const uint8 channel);

   virtual act_t sendRemoveSessionRequest(const ::std::string& session);

   virtual act_t sendCancelSessionRequest(const ::std::string& destination, const ::std::string& target, const ::std::string& source, const uint8 channel, const int32 instance);

   virtual act_t sendCancelSessionRequest(const ::std::string& destination, const ::std::string& target, const ::std::string& source, const uint8 channel);
   // IEvolutionGeniviDbusObexClientProxyIf implementation --- end

protected:
   EvolutionGeniviDbusObexClientProxyIf();

private:
   ::boost::shared_ptr< ClientProxy > _obexClientProxy;
   IEvolutionGeniviDbusObexClientCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROXY_IF_H_
