/**
 * @file EvolutionGeniviDbusLEDeviceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for LEDevice.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for LEDevice.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusLEDeviceSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/LE_Device1Proxy.h"

using namespace ::org::bluez::LE_Device1;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusLEDeviceCallbackIf;

/**
 * LEDevice proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusLEDeviceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusLEDeviceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusLEDeviceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusLEDeviceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusLEDeviceCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusLEDeviceProxyIf implementation --- start
   virtual act_t sendDisconnectRequest(const ::std::string& objPath);

   virtual act_t sendAddressTypeGet(const ::std::string& objPath);

   virtual act_t sendAddressGet(const ::std::string& objPath);

   virtual act_t sendConnectedGet(const ::std::string& objPath);
   // IEvolutionGeniviDbusLEDeviceProxyIf implementation --- end

protected:
   EvolutionGeniviDbusLEDeviceProxyIf();

private:
   ProxyManager< LE_Device1Proxy > _lEDeviceProxy;
   IEvolutionGeniviDbusLEDeviceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROXY_IF_H_
