/**
 * @file EvolutionGeniviDbusLEDeviceProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for LEDevice.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for LEDevice.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * LEDevice properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusLEDeviceProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusLEDeviceProperties();
   virtual ~EvolutionGeniviDbusLEDeviceProperties();

   LEDeviceProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const LEDeviceProperty value) const;
   const ::std::string& getProperty2StringTrace(const LEDeviceProperty value) const;

private:
   const ::std::string _propertyAddressType;
   const ::std::string _propertyAddress;
   const ::std::string _propertyConnected;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_LE_DEVICE_PROPERTIES_H_
