/**
 * @file EvolutionGeniviDbusLEAdapterProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for LEAdapter.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for LEAdapter.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_ADAPTER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_ADAPTER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusLEAdapterSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/LE_Adapter1Proxy.h"

using namespace ::org::bluez::LE_Adapter1;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusLEAdapterCallbackIf;

/**
 * LEAdapter proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusLEAdapterProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusLEAdapterSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusLEAdapterProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusLEAdapterProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusLEAdapterCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusLEAdapterProxyIf implementation --- start
   virtual act_t sendCreateLeDeviceRequest(const ::std::string& address);

   virtual act_t sendRemoveLeDeviceRequest(const ::std::string& device);

   virtual act_t sendAddressTypeGet(void);

   virtual act_t sendAddressGet(void);

   virtual act_t sendAliasGet(void);

   virtual void sendAliasSet(const ::std::string& alias);

   virtual act_t sendAdvertisingTimeoutGet(void);

   virtual void sendAdvertisingTimeoutSet(uint8 advertisingTimeout);

   virtual act_t sendDiscoverableModeGet(void);

   virtual void sendDiscoverableModeSet(uint8 discoverableMode);

   virtual act_t sendAdvertisingDataGet(void);

   virtual void sendAdvertisingDataSet(const ::std::vector< uint8 >& advertisingData);

   virtual act_t sendAdvertiseEnableGet(void);

   virtual void sendAdvertiseEnableSet(bool advertiseEnable);
   // IEvolutionGeniviDbusLEAdapterProxyIf implementation --- end

protected:
   EvolutionGeniviDbusLEAdapterProxyIf();

private:
   ::boost::shared_ptr< LE_Adapter1Proxy > _lEAdapterProxy;
   IEvolutionGeniviDbusLEAdapterCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_LE_ADAPTER_PROXY_IF_H_
