/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpVoiceCallManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/VoiceCallManagerProxy.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf;

/**
 * HfpVoiceCallManager proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallManagerProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpVoiceCallManagerProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpVoiceCallManagerProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpVoiceCallManagerProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendGetCallsRequest(const ::std::string& objPath);

   virtual act_t sendDialRequest(const ::std::string& objPath, const ::std::string& number, const ::std::string& hide_callerid);

   virtual act_t sendMemDialRequest(const ::std::string& objPath, uint16 numberindex, const ::std::string& hide_callerid);

   virtual act_t sendRedialRequest(const ::std::string& objPath, const ::std::string& hide_callerid);

   virtual act_t sendSwapCallsRequest(const ::std::string& objPath);

   virtual act_t sendReleaseAndAnswerRequest(const ::std::string& objPath);

   virtual act_t sendReleaseAndSwapRequest(const ::std::string& objPath);

   virtual act_t sendHoldAndAnswerRequest(const ::std::string& objPath);

   virtual act_t sendHangupAllRequest(const ::std::string& objPath);

   virtual act_t sendPrivateChatRequest(const ::std::string& objPath, const ::std::string& call);

   virtual act_t sendCreateMultipartyRequest(const ::std::string& objPath);

   virtual act_t sendHangupMultipartyRequest(const ::std::string& objPath);

   virtual act_t sendSendTonesRequest(const ::std::string& objPath, const ::std::string& sendTones);
   // IEvolutionGeniviDbusHfpVoiceCallManagerProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpVoiceCallManagerProxyIf();

private:
   ProxyManager< VoiceCallManagerProxy > _hfpVoiceCallManagerProxy;
   IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROXY_IF_H_
