/**
 * @file EvolutionGeniviDbusHfpSiriProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpSiri.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpSiri properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpSiriProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpSiriProperties();
   virtual ~EvolutionGeniviDbusHfpSiriProperties();

   HfpSiriProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const HfpSiriProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpSiriProperty value) const;

private:
   const ::std::string _propertyStatus;
   const ::std::string _propertyNR;
   const ::std::string _propertyEyesFreeMode;
   const ::std::string _propertySupportedType;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROPERTIES_H_
