/**
 * @file EvolutionGeniviDbusHfpManagerFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_FACTORY_H_

#include "BaseInstanceFactory.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusHfpManagerSendRequestIf;
class ICcDbusIfControllerClient;

/**
 *
 */
class EvolutionGeniviDbusHfpManagerFactory : public BaseInstanceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusHfpManagerFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IEvolutionGeniviDbusHfpManagerSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set proxy (pointer).
    * For testing purpose (unit test).
    * If proxy is set by external user via this interface the caller is responsible to free the proxy at the end of the test run.
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IEvolutionGeniviDbusHfpManagerSendRequestIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusHfpManagerFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusHfpManagerFactory();

   IEvolutionGeniviDbusHfpManagerSendRequestIf* _proxy; /**< proxy */
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_FACTORY_H_
