/**
 * @file EvolutionGeniviDbusHfpHandsfreeProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpHandsfree.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpHandsfree properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpHandsfreeProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpHandsfreeProperties();
   virtual ~EvolutionGeniviDbusHfpHandsfreeProperties();

   inline const ::std::map< std::string, int >& getFeatures2EnumList(void) const { return _features2EnumList; }
   inline const ::std::map< std::string, int >* getFeatures2EnumListPtr(void) const { return &_features2EnumList; }
   inline const ::std::map< int, const std::string* >& getFeatures2StringList(void) const { return _enum2FeaturesList; }
   inline const ::std::map< int, const std::string* >* getFeatures2StringListPtr(void) const { return &_enum2FeaturesList; }

   HfpHandsfreeProperty getProperty2Enum(const ::std::string& value) const;
   HfpHandsfreeFeatures getFeatures2Enum(const ::std::string& value) const;
   HfpHandsfreeChldFeatureSuppValues getChldFeature2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const HfpHandsfreeProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpHandsfreeProperty value) const;
   const ::std::string& getFeatures2String(const HfpHandsfreeFeatures value) const;
   const ::std::string& getFeatures2StringTrace(const HfpHandsfreeFeatures value) const;
   const ::std::string& getChldFeature2String(const HfpHandsfreeChldFeatureSuppValues value) const;

private:
   const ::std::string _propertyFeatures;
   const ::std::string _propertyInbandRinging;
   const ::std::string _propertyVoiceRecognition;
   const ::std::string _propertyEchoCancelingNoiseReduction;
   const ::std::string _propertyBatteryChargeLevel;
   const ::std::string _propertyAudio;
   const ::std::string _propertySCOType;
   const ::std::string _propertyAudioPath;
   const ::std::string _propertyAllCallStatus;
   const ::std::string _propertyChldFeature;
   const ::std::string _propertyAudioIndicator;

   const ::std::string _featuresVoice_recognition;
   const ::std::string _featuresAttach_voice_tag;
   const ::std::string _features3way;
   const ::std::string _featuresECNR;
   const ::std::string _featuresInband_ring;
   const ::std::string _featuresReject_incoming_call;
   const ::std::string _featuresEnhanced_call_status;
   const ::std::string _featuresEnhanced_call_control;
   const ::std::string _featuresExtended_error_codes;
   const ::std::string _featuresCodec_negotiation;
   const ::std::string _featuresHF_indicators;
   const ::std::string _featureseSCO_S4_and_T2_Setting_supported;

   const ::std::string _chldFeature_0;
   const ::std::string _chldFeature_1;
   const ::std::string _chldFeature_1x;
   const ::std::string _chldFeature_2;
   const ::std::string _chldFeature_2x;
   const ::std::string _chldFeature_3;
   const ::std::string _chldFeature_4;

   ::std::map< std::string, int > _features2EnumList; /**< map with supported value for Features + enum pairs */
   ::std::map< int, const std::string* > _enum2FeaturesList; /**< map with enum + supported value for Features pairs */

   ::std::map< std::string, int > _chldFeature2EnumList; /**< map with supported value for ChldFeature + enum pairs */
   ::std::map< int, const std::string* > _enum2ChldFeatureList; /**< map with enum + supported value for ChldFeature pairs */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROPERTIES_H_
