/**
 * @file EvolutionGeniviDbusHfpCallVolumeProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpCallVolume.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpCallVolume.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpCallVolumeSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/CallVolumeProxy.h"

using namespace ::org::ofono::CallVolume;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpCallVolumeCallbackIf;

/**
 * HfpCallVolume proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpCallVolumeProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpCallVolumeSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpCallVolumeProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpCallVolumeProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpCallVolumeCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpCallVolumeProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const uint8 value);
   // IEvolutionGeniviDbusHfpCallVolumeProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpCallVolumeProxyIf();

private:
   ProxyManager< CallVolumeProxy > _hfpCallVolumeProxy;
   IEvolutionGeniviDbusHfpCallVolumeCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROXY_IF_H_
