/**
 * @file EvolutionGeniviDbusHfpCallVolumeProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpCallVolume.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpCallVolume.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpCallVolume properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpCallVolumeProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpCallVolumeProperties();
   virtual ~EvolutionGeniviDbusHfpCallVolumeProperties();

   HfpCallVolumeProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const HfpCallVolumeProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpCallVolumeProperty value) const;

private:
   const ::std::string _propertySpeakerVolume;
   const ::std::string _propertyMicrophoneVolume;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_CALL_VOLUME_PROPERTIES_H_
