/**
 * @file EvolutionGeniviDbusHandleDeviceWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Proxy: work item for handle device.
 */


#ifndef _EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_WORK_ITEM_H_
#define _EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_WORK_ITEM_H_

#include "IWorkItem.h"

#include <string>
#include <stdbool.h> // <cstdbool> is marked with C++11

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusHandleDeviceIf;

/**
 *
 */
class EvolutionGeniviDbusHandleDeviceWorkItem : public IWorkItem
{
public:
   EvolutionGeniviDbusHandleDeviceWorkItem(IEvolutionGeniviDbusHandleDeviceIf* handleDeviceIf, bool deviceCreated, const ::std::string& objPath);
   virtual ~EvolutionGeniviDbusHandleDeviceWorkItem();
   virtual void processWorkItem(void);

protected:
   EvolutionGeniviDbusHandleDeviceWorkItem();

private:
   IEvolutionGeniviDbusHandleDeviceIf* _handleDeviceIf;
   bool _deviceCreated;
   ::std::string _objPath;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HANDLE_DEVICE_WORK_ITEM_H_
