/**
 * @file EvolutionGeniviDbusDunFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Dun.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Dun.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DUN_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_DUN_FACTORY_H_

#include "BaseInstanceFactory.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusDunSendRequestIf;
class ICcDbusIfControllerClient;

/**
 *
 */
class EvolutionGeniviDbusDunFactory : public BaseInstanceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusDunFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IEvolutionGeniviDbusDunSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set proxy (pointer).
    * For testing purpose (unit test).
    * If proxy is set by external user via this interface the caller is responsible to free the proxy at the end of the test run.
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IEvolutionGeniviDbusDunSendRequestIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusDunFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusDunFactory();

   IEvolutionGeniviDbusDunSendRequestIf* _proxy; /**< proxy */
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DUN_FACTORY_H_
