/**
 * @file EvolutionGeniviDbusDidFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Did.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DID_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_DID_FACTORY_H_

#include "BaseInstanceFactory.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusDidSendRequestIf;
class ICcDbusIfControllerClient;

/**
 *
 */
class EvolutionGeniviDbusDidFactory : public BaseInstanceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusDidFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IEvolutionGeniviDbusDidSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set proxy (pointer).
    * For testing purpose (unit test).
    * If proxy is set by external user via this interface the caller is responsible to free the proxy at the end of the test run.
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IEvolutionGeniviDbusDidSendRequestIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusDidFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusDidFactory();

   IEvolutionGeniviDbusDidSendRequestIf* _proxy; /**< proxy */
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DID_FACTORY_H_
