/**
 * @file EvolutionGeniviDbusDMProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for DM.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for DM.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DM_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DM_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusDMSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/alps/evo/DMProxy.h"

using namespace ::org::alps::evo::DM;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusDMCallbackIf;

/**
 * DM proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusDMProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusDMSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusDMProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusDMProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusDMCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusDMProxyIf implementation --- start
   virtual act_t sendBtApplDeviceConnectReqRequest(const ::std::vector< uint8 >& address, uint64 function, uint8 instance);

   virtual act_t sendBtApplDeviceDisconnectReqRequest(uint64 function, uint8 instance);

   virtual act_t sendBtApplCancelConnectReqRequest(void);

   virtual act_t sendBtApplGetHwVersionReqRequest(void);

   virtual act_t sendBtApplSetConfigurationReqRequest(uint8 instance, uint16 config_id, const ::std::vector< uint8 >& data);

   virtual act_t sendBtApplReadConfigurationReqRequest(uint8 instance, uint16 config_id);

   virtual act_t sendBtApplSspDebugModeReqRequest(uint8 mode);

   virtual act_t sendBtApplTestModeReqRequest(uint8 enable, uint8 mode, uint8 role, const ::std::vector< uint8 >& addr);

   virtual act_t sendBtApplTestModeLinkQualityReqRequest(uint8 mode);
   // IEvolutionGeniviDbusDMProxyIf implementation --- end

protected:
   EvolutionGeniviDbusDMProxyIf();

private:
   ::boost::shared_ptr< DMProxy > _dMProxy;
   IEvolutionGeniviDbusDMCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DM_PROXY_IF_H_
