/**
 * @file EvolutionGeniviDbusAgentStubIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS stub for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS stub for Agent.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_STUB_IF_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_STUB_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IEvolutionGeniviDbusAgentSendRequestIf.h"
#include "IEvolutionGeniviDbusAgentCallbackIf.h"
#include "CommonBaseProxyIf.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusAgentTestStubIf;

namespace evolution {

// class forward declarations
class EvolutionGeniviDbusAgentServer;

/**
 * Agent stub class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusAgentStubIf :
   public ISetCallback< IEvolutionGeniviDbusAgentCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IEvolutionGeniviDbusAgentSendRequestIf,
   public IEvolutionGeniviDbusAgentCallbackIf,
   public CommonBaseProxyIf
{
public:
   EvolutionGeniviDbusAgentStubIf(ICcDbusIfControllerClient* client);

   EvolutionGeniviDbusAgentStubIf(ICcDbusIfControllerClient* client, IEvolutionGeniviDbusAgentTestStubIf* testStubIf);

   EvolutionGeniviDbusAgentStubIf(const EvolutionGeniviDbusAgentStubIf& ref);

   EvolutionGeniviDbusAgentStubIf& operator=(const EvolutionGeniviDbusAgentStubIf& ref);

   virtual ~EvolutionGeniviDbusAgentStubIf();

   virtual void handleSetCallback(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IEvolutionGeniviDbusAgentSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableStub, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createStubIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyStubIf(const unsigned int callbackId, const bool destroyDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void sendReleaseResponse(const unsigned int callbackId, const act_t act);

   virtual void sendReleaseError(const unsigned int callbackId, const std::string& errorName, const std::string& errorMessage, const act_t act);

   virtual void sendRequestPinCodeResponse(const unsigned int callbackId, const ::std::string& pincode, const act_t act);

   virtual void sendRequestPinCodeError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendDisplayPinCodeResponse(const unsigned int callbackId, const act_t act);

   virtual void sendDisplayPinCodeError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendRequestPasskeyResponse(const unsigned int callbackId, uint32 passkey, const act_t act);

   virtual void sendRequestPasskeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendRequestConfirmationResponse(const unsigned int callbackId, const act_t act);

   virtual void sendRequestConfirmationError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendCancelResponse(const unsigned int callbackId, const act_t act);

   virtual void sendCancelRequestResponse(const unsigned int callbackId, const act_t act);

   virtual void sendAuthorizeServiceResponse(const unsigned int callbackId, const act_t act);

   virtual void sendAuthorizeServiceError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendRequestAuthorizationResponse(const unsigned int callbackId, const act_t act);

   virtual void sendRequestAuthorizationError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendRequestLinkkeyResponse(const unsigned int callbackId, const ::std::vector< uint8 >& linkkey, const act_t act);

   virtual void sendRequestLinkkeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);

   virtual void sendDisplayPasskeyResponse(const unsigned int callbackId, const act_t act);

   virtual void sendDisplayPasskeyError(const unsigned int callbackId, const ::std::string& errorName, const ::std::string& errorMessage, const act_t act);
   // IEvolutionGeniviDbusAgentSendRequestIf implementation --- end

   // IEvolutionGeniviDbusAgentCallbackIf implementation --- start
   virtual void onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request, const act_t act);

   virtual void onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request, const act_t act);

   virtual void onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request, const act_t act);

   virtual void onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request, const act_t act);

   virtual void onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request, const act_t act);

   virtual void onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request, const act_t act);

   virtual void onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request, const act_t act);

   virtual void onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request, const act_t act);

   virtual void onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request, const act_t act);

   virtual void onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request, const act_t act);

   virtual void onDisplayPasskeyRequest (const ::boost::shared_ptr< DisplayPasskeyRequest >& request, const act_t act);
   // IEvolutionGeniviDbusAgentCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

private:
   IEvolutionGeniviDbusAgentCallbackIf* _callbackIf; /**< callback interface (matches DbusBaseProxyIf::_callbackList) */
   EvolutionGeniviDbusAgentServer* _agentStub; /**< agent stub interface (matches DbusBaseProxyIf::_proxyList) */
   IEvolutionGeniviDbusAgentTestStubIf* _testStubIf; /**< test stub interface (matches DbusBaseProxyIf::_testProxyIf) */
   bool _stubCreated; /**< flag for created stub */

   void processSetCallback(IEvolutionGeniviDbusAgentCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   bool isStubAvailable(void) const;

   void addStub(void);

   void removeStub(void);

   void removeAllStubs(void);

   void removeCallbacks(void);
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_STUB_IF_H_
