/**
 * @file EvolutionGeniviDbusAgentManagerProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for AgentManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusAgentManagerSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/AgentManagerProxy.h"

using namespace ::org::bluez::AgentManager;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusAgentManagerCallbackIf;

/**
 * AgentManager proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusAgentManagerProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusAgentManagerSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusAgentManagerProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusAgentManagerProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusAgentManagerCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IEvolutionGeniviDbusAgentManagerProxyIf implementation --- start
   virtual act_t sendRegisterAgentRequest(const ::std::string& agent, const ::std::string& capability);

   virtual act_t sendUnregisterAgentRequest(const ::std::string& agent);

   virtual act_t sendRequestDefaultAgentRequest(const ::std::string& agent);
   // IEvolutionGeniviDbusAgentManagerProxyIf implementation --- end

protected:
   EvolutionGeniviDbusAgentManagerProxyIf();

private:
   ::boost::shared_ptr< AgentManagerProxy > _agentManagerProxy;
   IEvolutionGeniviDbusAgentManagerCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROXY_IF_H_
