/**
 * @file EvolutionGeniviDbusAgentFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Agent.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_FACTORY_H_

#include "IEvolutionGeniviDbusAgentSendRequestIf.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusAgentTestStubIf;
class ICcDbusIfControllerClient;

namespace evolution {

/**
 *
 */
class EvolutionGeniviDbusAgentFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusAgentFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IEvolutionGeniviDbusAgentSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set test proxy (pointer).
    * For testing purpose (unit test).
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IEvolutionGeniviDbusAgentTestStubIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusAgentFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusAgentFactory();

   IEvolutionGeniviDbusAgentSendRequestIf* _proxy; /**< proxy */
   IEvolutionGeniviDbusAgentTestStubIf* _testProxy; /**< test proxy */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_FACTORY_H_
