/**
 * @file EcNrDbusServiceCallbackIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EcNr DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EcNr DBUS callbacks.
 */

#include "EcNrDbusServiceCallbackIf.h"
#include "EcNrWrapper.h"

using namespace ::asf::core;

namespace ccdbusif {

EcNrDbusServiceCallbackIf::EcNrDbusServiceCallbackIf()
{
   _ecnrWrapper = NULL;
}

EcNrDbusServiceCallbackIf::EcNrDbusServiceCallbackIf(EcNrWrapper* ecnrWrapper)
{
   _ecnrWrapper = ecnrWrapper;
}

EcNrDbusServiceCallbackIf::~EcNrDbusServiceCallbackIf()
{
   _ecnrWrapper = NULL;
}

// "ServiceAvailableIF" implementation --- start
void EcNrDbusServiceCallbackIf::onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(previousState);
   (void)(objPath);

   _ecnrWrapper->handleServiceAvailability((ServiceState__Available == currentState));
}

void EcNrDbusServiceCallbackIf::onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(previousState);
   (void)(objPath);

   _ecnrWrapper->handleServiceAvailability((ServiceState__Available == currentState));
}
// "ServiceAvailableIF" implementation --- end

// serviceProxy implementation --- start
void EcNrDbusServiceCallbackIf::onEcnrDestroyError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->destroyResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrDestroyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->destroyResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrInitializeError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->initializeResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrInitializeResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->initializeResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrSetConfigurationError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->setConfigurationResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrSetConfigurationResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->setConfigurationResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrSetSendMuteSwitchError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->setSendMuteSwitchResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrSetSendMuteSwitchResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->setSendMuteSwitchResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrStartAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->startAudioResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrStartAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->startAudioResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrStopAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   _ecnrWrapper->stopAudioResultCB(ECNR_REQ_FAILED);
}

void EcNrDbusServiceCallbackIf::onEcnrStopAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(response);

   _ecnrWrapper->stopAudioResultCB(ECNR_REQ_SUCCESS);
}

void EcNrDbusServiceCallbackIf::onEcnrGetVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionError >& error)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);
   (void)(error);

   ::std::vector< uint32 > emptyVersion;
   ::std::string emptyVersionString("");
   ::std::string emptyVersionComment("");
   _ecnrWrapper->getVersionResultCB(ECNR_REQ_FAILED, emptyVersion, emptyVersionString, emptyVersionComment);
}

void EcNrDbusServiceCallbackIf::onEcnrGetVersionResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionResponse >& response)
{
   if(NULL == _ecnrWrapper)
   {
      return;
   }

   (void)(proxy);

   _ecnrWrapper->getVersionResultCB(ECNR_REQ_SUCCESS, response->getVersion(), response->getVersionString(), response->getVersionComment());
}
// serviceProxy implementation --- end

} //ccdbusif
