/**
 * @file IEcNrDbusServiceSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EcNr DBUS Send Request Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EcNr DBUS send requests.
 */

#ifndef _I_ECNR_DBUS_SERVICE_SEND_REQUEST_IF_H_
#define _I_ECNR_DBUS_SERVICE_SEND_REQUEST_IF_H_

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEcNrDbusServiceCallbackIf;

/**
 *
 */
class IEcNrDbusServiceSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEcNrDbusServiceSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableServiceProxy: flag to enable/disable service proxy
    */
   virtual void setCallbackIf(IEcNrDbusServiceCallbackIf* callbackIf, bool enableServiceProxy) = 0;

   /**
    * Send EcnrInitialize Request
    *
    * @param[in] ecnrAppId: application id
    * @param[in] ecnrConfigurationId: configuration id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrInitializeRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId) = 0;

   /**
    * Send EcnrDestroy Request
    *
    * @param[in] ecnrAppId: application id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrDestroyRequest(uint8 ecnrAppId) = 0;

   /**
    * Send EcnrSetConfiguration Request
    *
    * @param[in] ecnrAppId: application id
    * @param[in] ecnrConfigurationId: configuration id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrSetConfigurationRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId) = 0;

   /**
    * Send EcnrStartAudio Request
    *
    * @param[in] ecnrAppId: application id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrStartAudioRequest(uint8 ecnrAppId) = 0;

   /**
    * Send EcnrStopAudio Request
    *
    * @param[in] ecnrAppId: application id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrStopAudioRequest(uint8 ecnrAppId) = 0;

   /**
    * Send EcnrSetSendMuteSwitch Request
    *
    * @param[in] ecnrAppId: application id
    * @param[in] ecnrSendMuteSwitch: mute switch value
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrSetSendMuteSwitchRequest(uint8 ecnrAppId, uint8 ecnrSendMuteSwitch) = 0;

   /**
    * Send EcnrGetVersion Request
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendEcnrGetVersionRequest(void) = 0;
};

} //ccdbusif

#endif // _I_ECNR_DBUS_SERVICE_SEND_REQUEST_IF_H_
