/**
 * @file IEcNrDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EcNr DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EcNr DBUS callbacks.
 */

#ifndef _I_ECNR_DBUS_SERVICE_CALLBACK_IF_H_
#define _I_ECNR_DBUS_SERVICE_CALLBACK_IF_H_

#include "org/bosch/ecnr/serviceProxy.h"

using namespace ::org::bosch::ecnr::service;

using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 *
 */
class IEcNrDbusServiceCallbackIf :
   // from serviceProxy.h --- start
   public EcnrDestroyCallbackIF,
   public EcnrInitializeCallbackIF,
   public EcnrSetConfigurationCallbackIF,
   public EcnrSetSendMuteSwitchCallbackIF,
   public EcnrStartAudioCallbackIF,
   public EcnrStopAudioCallbackIF,
   public EcnrGetVersionCallbackIF
   // from serviceProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEcNrDbusServiceCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // serviceProxy implementation --- start
   virtual void onEcnrDestroyError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyError >& error) = 0;
   virtual void onEcnrDestroyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyResponse >& response) = 0;
   virtual void onEcnrInitializeError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeError >& error) = 0;
   virtual void onEcnrInitializeResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeResponse >& response) = 0;
   virtual void onEcnrSetConfigurationError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationError >& error) = 0;
   virtual void onEcnrSetConfigurationResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationResponse >& response) = 0;
   virtual void onEcnrSetSendMuteSwitchError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchError >& error) = 0;
   virtual void onEcnrSetSendMuteSwitchResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchResponse >& response) = 0;
   virtual void onEcnrStartAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioError >& error) = 0;
   virtual void onEcnrStartAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioResponse >& response) = 0;
   virtual void onEcnrStopAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioError >& error) = 0;
   virtual void onEcnrStopAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioResponse >& response) = 0;
   virtual void onEcnrGetVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionError >& error) = 0;
   virtual void onEcnrGetVersionResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionResponse >& response) = 0;
   // serviceProxy implementation --- end
};

} //ccdbusif

#endif // _I_ECNR_DBUS_SERVICE_CALLBACK_IF_H_
