/**
 * @file CcDbusIfLauncher.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ASF DBUS Launcher.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Launcher for ASF DBUS handling.
 */

#include "CcDbusIfLauncher.h"

namespace ccdbusif {

CcDbusIfLauncher::CcDbusIfLauncher()
{
   _applicationLaunched = false;
}

CcDbusIfLauncher::~CcDbusIfLauncher()
{
   if(true == _applicationLaunched)
   {
      _launcher.shutdown();
   }
}

void CcDbusIfLauncher::start(::asf::core::ApplicationLauncher::mainfptr mainFunction)
{
   if((NULL != mainFunction) && (true != _applicationLaunched))
   {
      _launcher.launch(mainFunction);
      _applicationLaunched = true;
   }
}

void CcDbusIfLauncher::start(::asf::core::ApplicationLauncher::mainfptr mainFunction, int argc, char** argv)
{
   if((NULL != mainFunction) && (true != _applicationLaunched))
   {
      _launcher.launch(mainFunction, argc, argv);
      _applicationLaunched = true;
   }
}

void CcDbusIfLauncher::stop(void)
{
   if(true == _applicationLaunched)
   {
      _launcher.shutdown();
      _applicationLaunched = false;
   }
}

} //ccdbusif
