/**
 * @file CcDbusIfDestroyRuntimeProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy runtime proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy runtime proxy work item.
 */

#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"

#include <cstddef>

namespace ccdbusif {

CcDbusIfDestroyRuntimeProxyWorkItem::CcDbusIfDestroyRuntimeProxyWorkItem()
{
   // _objPath
   _proxyDestroyer = NULL;
}

CcDbusIfDestroyRuntimeProxyWorkItem::CcDbusIfDestroyRuntimeProxyWorkItem(const ::std::string& objPath, ICcDbusIfDestroyRuntimeProxy* destroyer)
{
   _objPath = objPath;
   _proxyDestroyer = destroyer;
}

CcDbusIfDestroyRuntimeProxyWorkItem::~CcDbusIfDestroyRuntimeProxyWorkItem()
{
   _proxyDestroyer = NULL;
}

void CcDbusIfDestroyRuntimeProxyWorkItem::processWorkItem(void)
{
   if(NULL != _proxyDestroyer)
   {
      _proxyDestroyer->destroyRuntimeProxy(_objPath);
   }
}

} //ccdbusif
