/**
 * @file ICcDbusIfDestroyProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy Proxy.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy proxy for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_DESTROY_PROXY_H_
#define _I_CC_DBUS_IF_DESTROY_PROXY_H_

namespace ccdbusif {

/**
 *
 */
class ICcDbusIfDestroyProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfDestroyProxy() {}

   /**
    * Destroy proxy.
    */
   virtual void destroyProxy(void) = 0;

   /**
    * Destroy all runtime proxies.
    */
   virtual void destroyAllRuntimeProxies(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_DESTROY_PROXY_H_
