/**
 * @file ICcDbusIfControllerPropertiesGetAll.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Properties GetAll interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for Properties GetAll interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_PROPERTIES_GET_ALL_H_
#define _I_CC_DBUS_IF_CONTROLLER_PROPERTIES_GET_ALL_H_

namespace ccdbusif {

// class forward declarations
class IPropertiesGetAllDbusSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerPropertiesGetAll
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerPropertiesGetAll() {}

   virtual IPropertiesGetAllDbusSendRequestIf* getPropertiesGetAllProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_PROPERTIES_GET_ALL_H_
