/**
 * @file ICcDbusIfControllerObjectManager.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller ObjectManager interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for ObjectManager interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_OBJECT_MANAGER_H_
#define _I_CC_DBUS_IF_CONTROLLER_OBJECT_MANAGER_H_

namespace ccdbusif {

// class forward declarations
class IOrgFreedesktopDbusObjectManagerSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerObjectManager
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerObjectManager() {}

   virtual IOrgFreedesktopDbusObjectManagerSendRequestIf* getObjectManagerProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_OBJECT_MANAGER_H_
