/**
 * @file ICcDbusIfControllerIntrospectable.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Introspectable interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for Introspectable interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_INTROSPECTABLE_H_
#define _I_CC_DBUS_IF_CONTROLLER_INTROSPECTABLE_H_

namespace ccdbusif {

// class forward declarations
class IIntrospectableDbusSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerIntrospectable
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerIntrospectable() {}

   virtual IIntrospectableDbusSendRequestIf* getIntrospectableProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_INTROSPECTABLE_H_
