/**
 * @file ICcDbusIfControllerEcNr.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller EcNr interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for EcNr interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_ECNR_H_
#define _I_CC_DBUS_IF_CONTROLLER_ECNR_H_

namespace ccdbusif {

// class forward declarations
class IEcNrDbusServiceSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerEcNr
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerEcNr() {}

   virtual IEcNrDbusServiceSendRequestIf* getEcNrServiceProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_ECNR_H_
