/**
 * @file ICcDbusIfControllerDestroyAllProxies.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Client Destroy all proxies interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller destroy all proxies interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_DESTROY_ALL_PROXIES_H_
#define _I_CC_DBUS_IF_CONTROLLER_DESTROY_ALL_PROXIES_H_

namespace ccdbusif {

/**
 *
 */
class ICcDbusIfControllerDestroyAllProxies
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerDestroyAllProxies() {}

   virtual void destroyAllProxies(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_DESTROY_ALL_PROXIES_H_
