/**
 * @file ICcDbusIfControllerClient.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Client.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller client for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_CLIENT_H_
#define _I_CC_DBUS_IF_CONTROLLER_CLIENT_H_

#include "IWorkItem.h"

namespace ccdbusif {

/**
 *
 */
class ICcDbusIfControllerClient
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerClient() {}

   virtual void pushWorkItem(IWorkItem* workItem) = 0;

   virtual void destroyAllBluetoothRuntimeProxies(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_CLIENT_H_
