/**
 * @file CcDbusIfLaunchType.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Launch Type.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Launch type for CcDbusIf.
 */

#ifndef _CC_DBUS_IF_LAUNCH_TYPE_H_
#define _CC_DBUS_IF_LAUNCH_TYPE_H_

namespace ccdbusif {

/**
 * Launch type for ASF DBUS application library. Depending on agent functionality ("server") has to be provided or not a different application library has to be used.
 */
enum LaunchType
{
   PROXIES_ONLY = 0, /**< default mode, only proxies are used, no agent functionality necessary */
   WITH_EVOLUTION_AGENT /**< evolution genivi agent functionality is provided too */
};

} //ccdbusif

#endif //_CC_DBUS_IF_LAUNCH_TYPE_H_
