/**
 * @file CcDbusIfDestroyAllProxiesWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy all proxies work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy all proxies work item.
 */

#ifndef _CC_DBUS_IF_DESTROY_ALL_PROXIES_WORK_ITEM_H_
#define _CC_DBUS_IF_DESTROY_ALL_PROXIES_WORK_ITEM_H_

#include "IWorkItem.h"

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerDestroyAllProxies;

/**
 *
 */
class CcDbusIfDestroyAllProxiesWorkItem : public IWorkItem
{
public:
   CcDbusIfDestroyAllProxiesWorkItem(ICcDbusIfControllerDestroyAllProxies* destroyer);
   virtual ~CcDbusIfDestroyAllProxiesWorkItem();
   virtual void processWorkItem(void);

protected:
   CcDbusIfDestroyAllProxiesWorkItem();

private:
   ICcDbusIfControllerDestroyAllProxies* _destroyer;
};

} //ccdbusif

#endif //_CC_DBUS_IF_DESTROY_ALL_PROXIES_WORK_ITEM_H_
