/**
 * @file CcDbusIfControllerFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Factory.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller Factory for CcDbusIf.
 */

#ifndef _CC_DBUS_IF_CONTROLLER_FACTORY_H_
#define _CC_DBUS_IF_CONTROLLER_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

namespace ccdbusif {

// class forward declarations
class ICcDbusIfController;

/**
 *
 */
class CcDbusIfControllerFactory
{
public:
   /**
    * Get instance of controller factory (reference).
    *
    * @return = reference to controller factory object
    */
   static CcDbusIfControllerFactory& getInstance(void);

   /**
    * Get instance of controller (pointer).
    *
    * @return = pointer to controller object
    */
   ICcDbusIfController* getControllerInstance(void);

   /**
    * Destroy instance of controller (pointer).
    */
   void destroyControllerInstance(void);

   /**
    * Set instance of controller (pointer).
    * For testing purpose (unit test).
    * If instance is set by external user via this interface the caller is responsible to free the instance at the end of the test run.
    *
    * @param[in] testInstance: test version of generic stack if (pointer)
    */
   void setControllerInstanceForTesting(ICcDbusIfController* testInstance);

private:
   /**
    * Default constructor. Private!!!
    */
   CcDbusIfControllerFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~CcDbusIfControllerFactory();

   bool _controllerCreatedLocally;
   ICcDbusIfController* _controllerIf;
};

} //ccdbusif

#endif //_CC_DBUS_IF_CONTROLLER_FACTORY_H_
