/**
 * @file ConnManUtility.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan Utility.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan Utility.
 */

#include "ConnManUtility.h"
#include "FwAssert.h"

namespace ccdbusif {
namespace connman_utility {

static const ::std::string addressExample = "aabbccddeeff";
static const ::std::string typeBluetooth = "bluetooth";

void convertObjectPath2BDAddress(::std::string& bdAddress, const ::std::string& objectPath)
{
   // dirty solution
   // example: "/net/connman/service/bluetooth_34C731FF5A05_1C62B8BB9D7D"

   const size_t pos = objectPath.find_last_of('_');

   if(pos < objectPath.length())
   {
      if((pos + 1) < objectPath.length())
      {
         bdAddress = objectPath.substr(pos + 1);

         if(addressExample.length() != bdAddress.length())
         {
            // wrong objpath
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }
      else
      {
         // wrong objpath
         FW_NORMAL_ASSERT_ALWAYS();
      }
   }
   else
   {
      // wrong objpath
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

bool isBluetoothObjectPath(const ::std::string& objectPath)
{
   // dirty solution
   return (::std::string::npos != objectPath.find(typeBluetooth));
}

} //connman_utility
} //ccdbusif
