/**
 * @file ConnManDbusTechnologyProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Properties for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Properties for Technology.
 */

#include "ConnManDbusTechnologyProperties.h"

namespace ccdbusif {
namespace connman {

ConnManDbusTechnologyProperties::ConnManDbusTechnologyProperties() : DbusProperties("Technology"),
   // properties
   _propertyPowered("Powered"),
   _propertyConnected("Connected"),
   _propertyName("Name"),
   _propertyType("Type"),
   _propertyTethering("Tethering"),

   // type
   _typeSystem("system"),
   _typeEthernet("ethernet"),
   _typeWifi("wifi"),
   _typeBluetooth("bluetooth"),
   _typeCellular("cellular"),
   _typeGps("gps"),
   _typeVpn("vpn"),
   _typeGadget("gadget")
{
   _string2EnumList[_propertyPowered] = (int)TECHNOLOGY_POWERED;
   _string2EnumList[_propertyConnected] = (int)TECHNOLOGY_CONNECTED;
   _string2EnumList[_propertyName] = (int)TECHNOLOGY_NAME;
   _string2EnumList[_propertyType] = (int)TECHNOLOGY_TYPE;
   _string2EnumList[_propertyTethering] = (int)TECHNOLOGY_TETHERING;

   _enum2StringList[(int)TECHNOLOGY_POWERED] = &_propertyPowered;
   _enum2StringList[(int)TECHNOLOGY_CONNECTED] = &_propertyConnected;
   _enum2StringList[(int)TECHNOLOGY_NAME] = &_propertyName;
   _enum2StringList[(int)TECHNOLOGY_TYPE] = &_propertyType;
   _enum2StringList[(int)TECHNOLOGY_TETHERING] = &_propertyTethering;

   _type2EnumList[_typeSystem] = (int)SERVICE_TYPE_SYSTEM;
   _type2EnumList[_typeEthernet] = (int)SERVICE_TYPE_ETHERNET;
   _type2EnumList[_typeWifi] = (int)SERVICE_TYPE_WIFI;
   _type2EnumList[_typeBluetooth] = (int)SERVICE_TYPE_BLUETOOTH;
   _type2EnumList[_typeCellular] = (int)SERVICE_TYPE_CELLULAR;
   _type2EnumList[_typeGps] = (int)SERVICE_TYPE_GPS;
   _type2EnumList[_typeVpn] = (int)SERVICE_TYPE_VPN;
   _type2EnumList[_typeGadget] = (int)SERVICE_TYPE_GADGET;

   _enum2TypeList[(int)SERVICE_TYPE_SYSTEM] = &_typeSystem;
   _enum2TypeList[(int)SERVICE_TYPE_ETHERNET] = &_typeEthernet;
   _enum2TypeList[(int)SERVICE_TYPE_WIFI] = &_typeWifi;
   _enum2TypeList[(int)SERVICE_TYPE_BLUETOOTH] = &_typeBluetooth;
   _enum2TypeList[(int)SERVICE_TYPE_CELLULAR] = &_typeCellular;
   _enum2TypeList[(int)SERVICE_TYPE_GPS] = &_typeGps;
   _enum2TypeList[(int)SERVICE_TYPE_VPN] = &_typeVpn;
   _enum2TypeList[(int)SERVICE_TYPE_GADGET] = &_typeGadget;
}

ConnManDbusTechnologyProperties::~ConnManDbusTechnologyProperties()
{
}

TechnologyProperty ConnManDbusTechnologyProperties::getProperty2Enum(const ::std::string& value) const
{
   return (TechnologyProperty)convertString2Enum(value);
}

ServiceType ConnManDbusTechnologyProperties::getType2Enum(const ::std::string& value) const
{
   return (ServiceType)convertString2Enum(_type2EnumList, value);
}

const ::std::string& ConnManDbusTechnologyProperties::getProperty2String(const TechnologyProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& ConnManDbusTechnologyProperties::getProperty2StringTrace(const TechnologyProperty value) const
{
   if(TECHNOLOGY_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& ConnManDbusTechnologyProperties::getType2String(const ServiceType value) const
{
   if(SERVICE_TYPE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2TypeList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //connman
} //ccdbusif
