/**
 * @file ConnManDbusManagerProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Properties for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Properties for Manager.
 */

#include "ConnManDbusManagerProperties.h"

namespace ccdbusif {
namespace connman {

ConnManDbusManagerProperties::ConnManDbusManagerProperties() : DbusProperties("Manager"),
   // properties
   _propertyState("State"),
   _propertyOfflineMode("OfflineMode"),
   _propertySessionMode("SessionMode"),

   // state values
   _stateIdle("idle"),
   _stateOffline("offline"),
   _stateReady("ready"),
   _stateOnline("online")
{
   _string2EnumList[_propertyState] = (int)MANAGER_STATE;
   _string2EnumList[_propertyOfflineMode] = (int)MANAGER_OFFLINEMODE;
   _string2EnumList[_propertySessionMode] = (int)MANAGER_SESSIONMODE;

   _enum2StringList[(int)MANAGER_STATE] = &_propertyState;
   _enum2StringList[(int)MANAGER_OFFLINEMODE] = &_propertyOfflineMode;
   _enum2StringList[(int)MANAGER_SESSIONMODE] = &_propertySessionMode;

   _state2EnumList[_stateIdle] = (int)MANAGER_STATE_IDLE;
   _state2EnumList[_stateOffline] = (int)MANAGER_STATE_OFFLINE;
   _state2EnumList[_stateReady] = (int)MANAGER_STATE_READY;
   _state2EnumList[_stateOnline] = (int)MANAGER_STATE_ONLINE;

   _enum2stateList[(int)MANAGER_STATE_IDLE] = &_stateIdle;
   _enum2stateList[(int)MANAGER_STATE_OFFLINE] = &_stateOffline;
   _enum2stateList[(int)MANAGER_STATE_READY] = &_stateReady;
   _enum2stateList[(int)MANAGER_STATE_ONLINE] = &_stateOnline;
}

ConnManDbusManagerProperties::~ConnManDbusManagerProperties()
{
}

ManagerProperty ConnManDbusManagerProperties::getProperty2Enum(const ::std::string& value) const
{
   return (ManagerProperty)convertString2Enum(value);
}

ManagerState ConnManDbusManagerProperties::getState2Enum(const ::std::string& value) const
{
   return (ManagerState)convertString2Enum(_state2EnumList, value);
}

const ::std::string& ConnManDbusManagerProperties::getProperty2String(const ManagerProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& ConnManDbusManagerProperties::getProperty2StringTrace(const ManagerProperty value) const
{
   if(MANAGER_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& ConnManDbusManagerProperties::getState2String(const ManagerState value) const
{
   if(MANAGER_STATE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //connman
} //ccdbusif
