/**
 * @file ConnManDbusInterfaces.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Interfaces.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Interfaces.
 */

#include "ConnManDbusInterfaces.h"

#define FW_S_IMPORT_INTERFACE_ASSERT
#include "framework_if_if.h"

namespace ccdbusif {
namespace connman {

ConnManDbusInterfaces::ConnManDbusInterfaces() :
   _dummy(""),

   _interfaceManager("net.connman.Manager"),
   _interfaceService("net.connman.Service"),
   _interfaceTechnology("net.connman.Technology")
{
}

ConnManDbusInterfaces::~ConnManDbusInterfaces()
{
}

void ConnManDbusInterfaces::getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const
{
   interfaceList.reserve(matchingInterfaces.size());

   for(size_t i = 0; i < matchingInterfaces.size(); i++)
   {
      switch((Interface)matchingInterfaces[i])
      {
         case IF_MANAGER:
            interfaceList.push_back(_managerProperties.getString2EnumListPtr());
            break;
         case IF_SERVICE:
            interfaceList.push_back(_serviceProperties.getString2EnumListPtr());
            break;
         case IF_TECHNOLOGY:
            interfaceList.push_back(_technologyProperties.getString2EnumListPtr());
            break;
         default:
            FW_NORMAL_ASSERT_ALWAYS();
            break;
      }
   }
}

const ::std::string& ConnManDbusInterfaces::getInterfaceName(const Interface interface) const
{
   switch(interface)
   {
      case IF_MANAGER:
         return _interfaceManager;
         // break;
      case IF_SERVICE:
         return _interfaceService;
         // break;
      case IF_TECHNOLOGY:
         return _interfaceTechnology;
         // break;
      case IF_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         return _dummy;
         // break;
   }
}

} //connman
} //ccdbusif
