/**
 * @file IConnManDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Callback Interface for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for ConnMan DBUS callback for Service.
 */

#ifndef _I_CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_
#define _I_CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_

#include "net/connman/ServiceProxy.h"

using namespace ::net::connman::Service;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Service.
 */
class IConnManDbusServiceCallbackIf :
   // from net/connman/ServiceProxy.h --- start
   public GetPropertiesCallbackIF,
   public ConnectCallbackIF,
   public DisconnectCallbackIF,
   public PropertyChangedCallbackIF
   // from net/connman/ServiceProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnManDbusServiceCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // net/connman/ServiceProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

   virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;

   virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

   virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // net/connman/ServiceProxy implementation --- end
};

} //ccdbusif

#endif //_I_CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_
