/**
 * @file ConnManDbusTypes.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Types.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Types.
 */

#ifndef _CONN_MAN_DBUS_TYPES_H_
#define _CONN_MAN_DBUS_TYPES_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {
namespace connman {

/**
 * Type definition for interfaces.
 */
enum Interface
{
   IF_MANAGER = 0,
   IF_SERVICE,
   IF_TECHNOLOGY,
   // -------------------------------------------------------------------------
   IF_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Manager properties.
 */
enum ManagerProperty
{
   MANAGER_STATE = 0,
   MANAGER_OFFLINEMODE,
   MANAGER_SESSIONMODE,
   // -------------------------------------------------------------------------
   MANAGER_UNKNOWN /**< end marker, must be the last one */

};

/**
 * Type definition for Manager state.
 */
enum ManagerState
{
   MANAGER_STATE_IDLE = 0,
   MANAGER_STATE_OFFLINE,
   MANAGER_STATE_READY,
   MANAGER_STATE_ONLINE,
   // -------------------------------------------------------------------------
   MANAGER_STATE_UNKNOWN /*< end marker, must be the last one */
};

/**
 * Type definition for Service properties.
 * HINT: There are sub-properties (dictionary entries) which are doubled. Current DBUS property parser implementation does not support this.
 * HINT: But at the moment we are only interested in property entries which are not doubled. Therefore no change of DBUS property parser implementation is needed.
 */
enum ServiceProperty
{
   SERVICE_TYPE = 0,
   SERVICE_SECURITY,
   SERVICE_STATE,
   SERVICE_ERROR,
   SERVICE_STRENGTH,
   SERVICE_FAVORITE,
   SERVICE_IMMUTABLE,
   SERVICE_AUTOCONNECT,
   SERVICE_NAME,
   SERVICE_ROAMING,
   SERVICE_ETHERNET, // dict
   SERVICE_IPV4, // dict
   SERVICE_IPV4_CONFIGURATION, // dict
   SERVICE_IPV6, // dict
   SERVICE_IPV6_CONFIGURATION, // dict
   SERVICE_NAMESERVERS,
   SERVICE_NAMESERVERS_CONFIGURATION,
   SERVICE_TIMESERVERS,
   SERVICE_TIMESERVERS_CONFIGURATION,
   SERVICE_DOMAINS,
   SERVICE_DOMAINS_CONFIGURATION,
   SERVICE_PROXY, // dict
   SERVICE_PROXY_CONFIGURATION, // dict
   SERVICE_PROVIDER, // dict
   // -------------------------------------------------------------------------
   SERVICE_ETHERNET_METHOD,
   SERVICE_ETHERNET_INTERFACE,
   SERVICE_ETHERNET_ADDRESS,
   SERVICE_ETHERNET_MTU,
   SERVICE_ETHERNET_SPEED,
   SERVICE_ETHERNET_DUPLEX,
   // -------------------------------------------------------------------------
   SERVICE_IPV4_METHOD,
   SERVICE_IPV4_ADDRESS,
   SERVICE_IPV4_NETMASK,
   SERVICE_IPV4_GATEWAY,
   // -------------------------------------------------------------------------
   SERVICE_IPV6_METHOD,
   SERVICE_IPV6_ADDRESS,
   SERVICE_IPV6_PREFIX_LENGTH,
   SERVICE_IPV6_GATEWAY,
   SERVICE_IPV6_PRIVACY,
   // -------------------------------------------------------------------------
   SERVICE_PROXY_METHOD,
   SERVICE_PROXY_URL,
   SERVICE_PROXY_SERVERS,
   SERVICE_PROXY_EXCLUDES,
   // -------------------------------------------------------------------------
   SERVICE_PROVIDER_HOST,
   SERVICE_PROVIDER_DOMAIN,
   SERVICE_PROVIDER_NAME,
   SERVICE_PROVIDER_TYPE,
   // -------------------------------------------------------------------------
   SERVICE_UNKNOWN, /**< end marker, must be the last one */
};

/**
 * Type definition for Service state.
 */
enum ServiceState
{
   SERVICE_STATE_IDLE = 0,
   SERVICE_STATE_FAILURE,
   SERVICE_STATE_ASSOCIATION,
   SERVICE_STATE_CONFIGURATION,
   SERVICE_STATE_READY,
   SERVICE_STATE_DISCONNECT,
   SERVICE_STATE_ONLINE,
   // -------------------------------------------------------------------------
   SERVICE_STATE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Service type.
 */
enum ServiceType
{
   SERVICE_TYPE_SYSTEM = 0,
   SERVICE_TYPE_ETHERNET,
   SERVICE_TYPE_WIFI,
   SERVICE_TYPE_BLUETOOTH,
   SERVICE_TYPE_CELLULAR,
   SERVICE_TYPE_GPS,
   SERVICE_TYPE_VPN,
   SERVICE_TYPE_GADGET,
   // -------------------------------------------------------------------------
   SERVICE_TYPE_UNKNOWN /**< end marker, must be the last one */
};

/**
 * Type definition for Technology properties.
 */
enum TechnologyProperty
{
   TECHNOLOGY_POWERED = 0,
   TECHNOLOGY_CONNECTED,
   TECHNOLOGY_NAME,
   TECHNOLOGY_TYPE,
   TECHNOLOGY_TETHERING,
   // -------------------------------------------------------------------------
   TECHNOLOGY_UNKNOWN /**< end marker, must be the last one */
};

} //connman
} //ccdbusif

#endif //_CONN_MAN_DBUS_TYPES_H_
