/**
 * @file ConnManDbusTechnologyProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Proxy for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS proxy for Technology.
 */

#ifndef _CONN_MAN_DBUS_TECHNOLOGY_PROXY_IF_H_
#define _CONN_MAN_DBUS_TECHNOLOGY_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IConnManDbusTechnologySendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "net/connman/TechnologyProxy.h"

using namespace ::net::connman::Technology;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IConnManDbusTechnologyCallbackIf;

/**
 * Technology proxy class for ConnMan interface.
 */
class ConnManDbusTechnologyProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IConnManDbusTechnologySendRequestIf,
   public BaseDbusProxyIf
{
public:
   ConnManDbusTechnologyProxyIf(ICcDbusIfControllerClient* client);
   virtual ~ConnManDbusTechnologyProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IConnManDbusTechnologyCallbackIf* callbackIf, bool enableProxy);

   virtual void technologyCreated(const ::std::string& objPath);

   virtual void technologyRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IConnManDbusTechnologyProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);
   // IConnManDbusTechnologyProxyIf implementation --- end

protected:
   ConnManDbusTechnologyProxyIf();

private:
   ProxyManager< TechnologyProxy > _technologyProxy;
   IConnManDbusTechnologyCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_CONN_MAN_DBUS_TECHNOLOGY_PROXY_IF_H_
